clear all;
close all;

A = importdata('0T_Sweep_Up.dat');
Data(:,1) = A(:,2);
Data(:,2) = A(:,3);
R_0T = A(:,2);
T_0T = A(:,3);

A = importdata('0.5T_Sweep_Up.dat');
Data(:,3) = A(:,2);
Data(:,4) = A(:,3);

A = importdata('1T_Sweep_Up.dat');
Data(:,5) = A(:,2);
Data(:,6) = A(:,3);

A = importdata('1.5T_Sweep_Up.dat');
Data(:,7) = A(:,2);
Data(:,8) = A(:,3);

A = importdata('2T_Sweep_Up.dat');
Data(:,9) = A(:,2);
Data(:,10) = A(:,3);

A = importdata('2.5T_Sweep_Up.dat');
Data(:,11) = A(:,2);
Data(:,12) = A(:,3);

A = importdata('3T_Sweep_Up.dat');
Data(:,13) = A(:,2);
Data(:,14) = A(:,3);

A = importdata('3.5T_Sweep_Up.dat');
Data(:,15) = A(:,2);
Data(:,16) = A(:,3);

A = importdata('4T_Sweep_Up.dat');
Data(:,17) = A(:,2);
Data(:,18) = A(:,3);

A = importdata('4.5T_Sweep_Up.dat');
Data(:,19) = A(:,2);
Data(:,20) = A(:,3);

figure;
hold on;
box on;
for i = 1:10
    plot(Data(:,(i*2)),Data(:,(i*2)-1),'linewidth',2);
end
set(gca,'fontsize',15,'fontname','times');
set(gcf,'color','w');
xlabel('Temperature (K)','fontsize',20,'fontname','times');
ylabel('Field (\Omega)','fontsize',20,'fontname','times');
box on;
title('Temperature Sweeps ||_c');
legend('0T','0.5T','1T','1.5T','2T','2.5T','3T','3.5T','4T','4.5T');
legend('location', 'SouthEast');
set(legend,'FontSize',10);
legend boxoff
xlim([2 8]);
hold off;
